#cs ----------------------------------------------------------------------------

 Remmanaut, the autoit RMM tool

 Script function:		Agent connector, communicates with Remmanaut agents
 Version:				0.2.3

 Author:				Faldo / Erik Ribbhammar
 UDF Credits:			lod3n (_RunReadStd), dantay9 (TCP File Transfer),
						Prog@ndy (MySQL, _TCPconnect), Greg Laabs (_http)
 Helping Credits:

#ce ----------------------------------------------------------------------------
#NoTrayIcon
#include <File.au3>
#include <Array.au3>
#include <Date.au3>
#include <Crypt.au3>
#include <mysql.au3>

;Predefined variables
Global $Version = "0.3"
Global $ListenIP = "0.0.0.0"
Global $MsgPort = IniRead ( "settings.ini", "variables", "MsgPort", "5076" )
Global $DBName = "remmanaut"
Global $Listen, $Client, $Recv, $MySQLSession, $query, $SQL_Result, $result, $RecvArray


;Start TCP server
TCPStartup()
$Listen = TCPListen($ListenIP, $MsgPort)
If @error Or $Listen = '-1' Then
	Exit _FileWriteLog(@ScriptDir & "\log.txt", "Unable to start agent connector, exiting...")
Else
	_FileWriteLog(@ScriptDir & "\log.txt", "Agent connector listening on port "&$MsgPort)
EndIf

;Main loop
While 1
	;Wait for agent to create a session
	Do
		$Client = TCPAccept($Listen)
		Sleep('100')
	Until $Client <> '-1'

	;Wait for agent to send a message
	For $i = 1 to 10
		$Recv = TCPRecv($Client, '1000')
		Sleep('100')
		If $Recv <> '' then ExitLoop
	Next

	;Split message from agent into header och payload
	$RecvArray = StringSplit($Recv, "|")

	;----------------------------
	;Version verification
	If $RecvArray[1] = "version" Then
		TCPSend($Client, $Version)
	EndIf

	;----------------------------
	;An agent has started, reply with online-message
	If $RecvArray[1] = "online" Then
		_Open_MySql($DBName)

		;Check if agent_id exist in DB
		$query = "SELECT EXISTS(SELECT * FROM agents WHERE agent_id="&$RecvArray[3]&");"
		$SQL_Result = _MySQL_Real_Query($MySQLSession, $query)
		If $SQL_Result = 0 then
			$result = _MySQL_Store_Result($MySQLSession)
			$array = _MySQL_Fetch_Result_StringArray($result)
			;Agent checks in for the fist time, create new agent in table "agents"
			If $array[1][0] = 0 then
				$AgentName = $RecvArray[2]
				$AgentID = $RecvArray[3]
				$query =	'INSERT INTO agents (agent_id,agent_name,checkin_interval,first_checkin,last_checkin,status,working_dir) VALUES (' & _
							'"'&$AgentID&'","'&$AgentName&'","5000","'&_NowCalc()&'","'&_NowCalc()&'","idle","c:\\remmanaut");'
				$SQL_Return = _MySQL_Real_Query($MysqlSession, $query)
				If $SQL_Return > 0 then
					_FileWriteLog(@ScriptDir & "\log.txt", "MySQL error while creating new agent: "& _MySQL_Error($MysqlSession))
				Else
					_FileWriteLog(@ScriptDir & "\log.txt", "New agent "&$AgentName&" added.")
				EndIf
			EndIf
			_MySQL_Free_Result($result)
		Else
			_FileWriteLog(@ScriptDir & "\log.txt", "MySQL error while selecting: "& _MySQL_Error($MysqlSession))
		EndIf
		_Close_MySql()

		_FileWriteLog(@ScriptDir & "\log.txt", "Agent " & $RecvArray[2] & " has come online.")
		TCPSend($Client, "online|")
	EndIf

	;----------------------------
	;Reply to agent_settings with checkin_interval and working_dir
	If $RecvArray[1] = "agent_settings" Then
		$AgentID = $RecvArray[2]
		_Open_MySql($DBName)
		$query = "SELECT * FROM agents WHERE agent_id="&$AgentID&";"
		$SQL_Result = _MySQL_Real_Query($MySQLSession, $query)
		$result = _MySQL_Store_Result($MySQLSession)
		$array = _MySQL_Fetch_Result_StringArray($result)
		_Close_MySql()
		$checkin_interval = $array[1][5]
		$working_dir = $array[1][6]
		TCPSend($Client, $checkin_interval&"|"&$working_dir)
	EndIf

	;Reply to verify_local_files with list of files and hashes
	If $RecvArray[1] = "verify_local_files" Then
		$AgentID = $RecvArray[2]
		_Open_MySql($DBName)
		$query = "SELECT * FROM agent_systemfiles;"
		$SQL_Result = _MySQL_Real_Query($MySQLSession, $query)
		$result = _MySQL_Store_Result($MySQLSession)
		$array = _MySQL_Fetch_Result_StringArray($result)
		_Close_MySql()
		$files = _ArrayToString($array, "|", 1)
		$files = StringReplace($files, @CRLF, "|")
		TCPSend($Client, $files)
	EndIf


	;----------------------------
	;If action in queue, reply to request_action with action|payload1|payload2...
	If $RecvArray[1] = "request_action" Then
		$AgentID = $RecvArray[2]
		_Open_MySql($DBName)

		;Update last_checkin
		$query = "UPDATE agents SET last_checkin='"&_NowCalc()&"' WHERE agent_id='"&$AgentID&"'"
		$SQL_Result = _MySQL_Real_Query($MySQLSession, $query)
		If $SQL_Result > 0 then _FileWriteLog(@ScriptDir & "\log.txt", "Update error: "& _MySQL_Error($MysqlSession))

		;Check if there are queued actions
		$query = "SELECT * FROM action_queue WHERE agent_id="&$AgentID&";"
		$SQL_Result = _MySQL_Real_Query($MySQLSession, $query)
		$result = _MySQL_Store_Result($MySQLSession)
		$action_queue_array = _MySQL_Fetch_Result_StringArray($result)
		If IsArray($action_queue_array) Then
			For $i = 1 to UBound($action_queue_array)-1
				;Verify action schedule
				$schedule = _DateDiff('s', $action_queue_array[$i][2], _NowCalc())

				If $schedule > 1 Then
					$action = $action_queue_array[$i][3]
					;--------------------------------------------------------
					;If queued action is change_checkin, forward action and new loop timer
					If $action = "new_checkin_interval" Then
						_FileWriteLog(@ScriptDir & "\log.txt", "Action new_checkin_interval has been issued.")
						$checkin_interval = $action_queue_array[$i][4]
						TCPSend($Client, $action & "|" & $checkin_interval)
					EndIf
					;----------------------------
					;If action is CMD_SYSUSER, reply with action and instructions
					If $action = "cmd_sysuser" Then
						_FileWriteLog(@ScriptDir & "\log.txt", "Action CMD_SYSUSER has been issued.")
						$command = $action_queue_array[$i][4]
						$interactive = $action_queue_array[$i][5]
						$runwait = $action_queue_array[$i][6]
						TCPSend($Client, $action & "|" & $command & "|" & $interactive & "|" & $runwait)
					EndIf
					;----------------------------
					;If action is CMD_ASUSER, reply with action and cmd instructions
					If $action = "cmd_asuser" Then
						_FileWriteLog(@ScriptDir & "\log.txt", "Action CMD_ASUSER has been issued.")
						$command = $action_queue_array[$i][4]
						$interactive = $action_queue_array[$i][5]
						$user = $action_queue_array[$i][6] & $action_queue_array[1][7]
						$password = $action_queue_array[$i][8]
						$runwait = $action_queue_array[$i][9]
						TCPSend($Client, $action & "|" & $command & "|" & $interactive & "|" & $user & "|" & $password& "|" & $runwait)
					EndIf
					;----------------------------
					;If action is FILETRANSFER_FROM_AGENT, reply with path+filename. Initiate new TCP and await file reception.
					If $action = "filetransfer_from_agent" Then
						$agent_file = $action_queue_array[$i][4]
						_FileWriteLog(@ScriptDir & "\log.txt", "Action FILETRANSFER_FROM_AGENT has been issued, agent sending file " & $agent_file)
						TCPSend($Client, $action & "|" & $agent_file)
					EndIf

					;----------------------------
					;If action is FILETRANSFER_TO_AGENT, reply with path+filename. Initiate new TCP and send file.
					If $action = "filetransfer_to_agent" Then
						$agent_path = $action_queue_array[$i][4]
						$server_filename = $action_queue_array[$i][5]
						_FileWriteLog(@ScriptDir & "\log.txt", "Action FILETRANSFER_TO_AGENT has been issued, agent requesting file " & $server_filename)
						TCPSend($Client, $action & "|" & $agent_path &"|"& $server_filename)
					EndIf

					;--------------------------------------------------------
					;Prepare remote control by sending uvnc.exe setup file
					If $action = "prepare_rc" Then
						TCPSend($Client, $action & "|filetransfer_uvnc.exe")
						Run("FileTransfer.exe to_agent c:\remmanaut\uvnc.exe")
					EndIf

					;--------------------------------------------------------

					;Delete action from queue
					$rowID = $action_queue_array[$i][0]
					$query = "DELETE FROM action_queue WHERE RowId="&$rowID&";"
					$SQL_Result = _MySQL_Real_Query($MySQLSession, $query)
					ExitLoop
				Else
					If $i = UBound($action_queue_array)-1 then TCPSend($Client, "before schedule")
				EndIf
			Next
		Else
			TCPSend($Client, "no action queued")
		EndIf
		_MySQL_Free_Result($result)
		_Close_MySql()
	EndIf
WEnd

TCPCloseSocket($Client)
TCPShutdown()
Exit


; Functions -----------------------------------------------------

Func _Open_MySQL($DB)
	;Initiate MySql library
	_MySQL_InitLibrary()
	If @error Then _FileWriteLog(@ScriptDir & "\log.txt", "Error initiating MySQL")

	;Initiate MySQL connection and connect to root
	$MySQLSession = _MySQL_Init()
	$Connection = _MySQL_Real_Connect($MysqlSession,"localhost","root","")
	If $Connection = 0 Then
		$errno = _MySQL_errno($MysqlSession)
		_FileWriteLog(@ScriptDir & "\log.txt", "MySQL error while selecting: "& _MySQL_Error($MysqlSession))
		If $errno = $CR_UNKNOWN_HOST Then _FileWriteLog(@ScriptDir & "\log.txt", "Error:","$CR_UNKNOWN_HOST" & @LF & $CR_UNKNOWN_HOST)
	Endif

	;Select databse for Use
	$SQL_Return = _MySQL_Real_Query($MysqlSession, "USE "&$DB)
	If $SQL_Return <> 0 then
		_FileWriteLog(@ScriptDir & "\log.txt", "MySQL error: "& _MySQL_Error($MysqlSession))
	EndIf
EndFunc

Func _Close_MySql()
	;Close the MySql session
	_MySQL_Close($MysqlSession)
	;Close the MySql library
	_MySQL_EndLibrary()
EndFunc
